<?php
require 'db_plain.php';

if (!isset($con)) {
    die("Unable to establish a database connection!");
}

if (isset($_GET['export']) && $_GET['export'] == 'excel') {
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=Farmer_Loan_Report_" . date('Y-m-d') . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");

    $sql = getReportSQL();
    $result = $con->query($sql);

    echo '<html><head><meta charset="UTF-8"></head><body>';
    echo '<table border="1">';
    echo '<tr>
        <th>Sl</th><th>Farmer Name</th><th>Father Name</th><th>Saving A/C</th>
        <th>Rabi Loan A/C</th><th>Kharif Loan A/C</th><th>EFT A/C</th><th>Village</th>
        <th>Pin Code</th><th>Name of PACS</th><th>Gender</th><th>Category</th>
        <th>Mobile</th><th>Date of Birth</th><th>Aadhar Number</th><th>PAN Number</th>
        <th>Voter Name</th><th>Rabi Amount</th><th>Kharif Amount</th><th>Loan Outstanding</th>
    </tr>';

    $sl = 1;
    while ($row = $result->fetch_assoc()) {
        echo '<tr>';
        echo '<td>' . $sl++ . '</td>';
        echo '<td>' . $row['Farmaers_name'] . '</td>';
        echo '<td>' . $row['Father_name'] . '</td>';
        echo '<td>' . $row['Saving_account'] . '</td>';
        echo '<td>' . $row['Rabi_Loan_acc'] . '</td>';
        echo '<td>' . $row['Kharif_Loan_acc'] . '</td>';
        echo '<td>' . $row['EFT_acc'] . '</td>';
        echo '<td>' . $row['Village'] . '</td>';
        echo '<td>' . $row['Pin_code'] . '</td>';
        echo '<td>' . $row['Name_of_pacs'] . '</td>';
        echo '<td>' . $row['gender'] . '</td>';
        echo '<td>' . $row['catagory'] . '</td>';
        echo '<td>' . $row['mobile'] . '</td>';
        echo '<td>' . $row['date_of_birth'] . '</td>';
        echo '<td>' . $row['Aadher_number'] . '</td>';
        echo '<td>' . $row['Pan_number'] . '</td>';
        echo '<td>' . $row['Voter_name'] . '</td>';
        echo '<td style="text-align:right;">' . number_format($row['Rabi_Amount'], 2) . '</td>';
        echo '<td style="text-align:right;">' . number_format($row['Kharif_Amount'], 2) . '</td>';
        echo '<td style="text-align:right;">' . number_format($row['Loan_outstanding'], 2) . '</td>';
        echo '</tr>';
    }
    echo '</table></body></html>';
    exit;
}

function getReportSQL() {
    $sql = "SELECT 
      CONCAT(j.fname,' ', j.mname,' ', j.lname) AS Farmaers_name,
      j.father_name AS Father_name,
      j.acc_no AS Saving_account,
      laA.rabi_acc_no AS Rabi_Loan_acc,
      laB.kharif_acc_no AS Kharif_Loan_acc,
      dc.bankacc AS EFT_acc,
      j.address AS Village,
      j.pin AS Pin_code,
      (SELECT name FROM bank_details LIMIT 1) AS Name_of_pacs,
      j.gender,
      j.cust AS catagory,
      j.mobile,
      j.dob AS date_of_birth,
      j.adhar AS Aadher_number,
      j.pan AS Pan_number,
      j.voter AS Voter_name,
      laA.rabi_amt AS Rabi_Amount,
      laB.kharif_amt AS Kharif_Amount,
      (
        COALESCE((
          SELECT COALESCE(SUM(v.dr),0) - COALESCE(SUM(v.cr),0)
          FROM voucher v
          WHERE v.acc_no = laA.rabi_acc_no
            AND v.sub_head = '23101A'
        ),0)
        +
        COALESCE((
          SELECT COALESCE(SUM(v.dr),0) - COALESCE(SUM(v.cr),0)
          FROM voucher v
          WHERE v.acc_no = laB.kharif_acc_no
            AND v.sub_head = '23101B'
        ),0)
      ) AS Loan_outstanding
    FROM applicant j
    JOIN deposit_acc dc 
      ON dc.acc_no = j.acc_no AND dc.acc_type='SV'
    LEFT JOIN (
      SELECT loan_against_sv_acc, MAX(acc_no) AS rabi_acc_no, MAX(amt) AS rabi_amt
      FROM loan_acc
      WHERE sub_head='23101A'
      GROUP BY loan_against_sv_acc
    ) laA ON laA.loan_against_sv_acc = j.acc_no
    LEFT JOIN (
      SELECT loan_against_sv_acc, MAX(acc_no) AS kharif_acc_no, MAX(amt) AS kharif_amt
      FROM loan_acc
      WHERE sub_head='23101B'
      GROUP BY loan_against_sv_acc
    ) laB ON laB.loan_against_sv_acc = j.acc_no";

    return $sql;
}

$sql = getReportSQL();
$result = $con->query($sql);

$pacs_result = $con->query("SELECT name FROM bank_details LIMIT 1");
$pacs_name = '';
if ($pacs_row = $pacs_result->fetch_assoc()) {
    $pacs_name = $pacs_row['name'];
}

$totalRabi = 0;
$totalKharif = 0;
$totalOutstanding = 0;
$rows = array();
while ($row = $result->fetch_assoc()) {
    $rows[] = $row;
    $totalRabi += floatval($row['Rabi_Amount']);
    $totalKharif += floatval($row['Kharif_Amount']);
    $totalOutstanding += floatval($row['Loan_outstanding']);
}
$totalRecords = count($rows);
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Farmer Loan Report - <?php echo htmlspecialchars($pacs_name); ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; background: #f0f2f5; color: #333; }
        .header-bar {
            background: linear-gradient(135deg, #1a5276, #2e86c1);
            color: #fff; padding: 14px 24px; display: flex; align-items: center;
            justify-content: space-between; position: sticky; top: 0; z-index: 100;
            box-shadow: 0 2px 8px rgba(0,0,0,.15);
        }
        .header-bar h2 { font-size: 16px; font-weight: 600; }
        .header-bar .sub { font-size: 11px; opacity: .85; margin-top: 2px; }
        .btn-group { display: flex; gap: 8px; }
        .btn {
            padding: 7px 16px; border: none; border-radius: 4px; font-size: 12px;
            font-weight: 600; cursor: pointer; display: inline-flex; align-items: center;
            gap: 5px; transition: .2s; text-decoration: none;
        }
        .btn:hover { opacity: .88; transform: translateY(-1px); }
        .btn-pdf { background: #e74c3c; color: #fff; }
        .btn-excel { background: #27ae60; color: #fff; }
        .summary-strip {
            display: flex; gap: 16px; padding: 12px 24px; background: #fff;
            border-bottom: 1px solid #ddd; flex-wrap: wrap;
        }
        .summary-card {
            background: #f8f9fa; border: 1px solid #e0e0e0; border-radius: 6px;
            padding: 8px 16px; min-width: 160px;
        }
        .summary-card .label { font-size: 10px; color: #777; text-transform: uppercase; letter-spacing: .5px; }
        .summary-card .value { font-size: 16px; font-weight: 700; color: #1a5276; margin-top: 2px; }
        .table-wrapper { padding: 16px 20px; overflow-x: auto; }
        table {
            width: 100%; border-collapse: collapse; background: #fff;
            box-shadow: 0 1px 4px rgba(0,0,0,.08); font-size: 11px;
        }
        thead th {
            background: #1a5276; color: #fff; padding: 8px 6px; text-align: center;
            font-size: 10px; font-weight: 600; white-space: nowrap;
        }
        tbody td { padding: 5px 6px; border-bottom: 1px solid #eee; white-space: nowrap; }
        tbody tr:hover { background: #eaf2f8; }
        tbody tr:nth-child(even) { background: #fafbfc; }
        tbody tr:nth-child(even):hover { background: #eaf2f8; }
        .text-right { text-align: right; }
        .text-center { text-align: center; }
        .font-bold { font-weight: 700; }
        tfoot td { padding: 8px 6px; background: #1a5276; color: #fff; font-weight: 700; font-size: 11px; }
        .record-count { padding: 8px 24px; font-size: 11px; color: #666; }

        /* ─── Print Header (hidden on screen) ─── */
        .print-header { display: none; }
        .print-summary { display: none; }

        @media print {
            body { background: #fff; }
            .header-bar { position: static; background: #1a5276 !important; -webkit-print-color-adjust: exact; print-color-adjust: exact; }
            .btn-group { display: none !important; }
            .summary-strip { display: none !important; }
            .record-count { display: none !important; }
            .table-wrapper { padding: 4px 0; }

            /* ─── FIXED: Print header & summary visible ─── */
            .print-header {
                display: block !important;
                text-align: center;
                margin-bottom: 6px;
                padding: 8px 0;
            }
            .print-summary {
                display: block !important;
                text-align: center;
                font-size: 10px;
                margin-bottom: 6px;
                padding: 4px 0;
                border-bottom: 1px solid #333;
            }

            thead th {
                background: #1a5276 !important; color: #fff !important;
                -webkit-print-color-adjust: exact; print-color-adjust: exact;
            }
            tfoot td {
                background: #1a5276 !important; color: #fff !important;
                -webkit-print-color-adjust: exact; print-color-adjust: exact;
            }
            table { font-size: 9px; box-shadow: none; }
            thead { display: table-header-group; }
            tfoot { display: table-footer-group; }
            tr { page-break-inside: avoid; }
            @page { size: A4 landscape; margin: 0.5cm; }
        }
    </style>
</head>
<body>

<!-- Screen Header Bar -->
<div class="header-bar">
    <div>
        <h2>Farmer Loan Report</h2>
        <div class="sub"><?php echo htmlspecialchars($pacs_name); ?> | Generated: <?php echo date('d-M-Y h:i A'); ?></div>
    </div>
    <div class="btn-group">
        <button class="btn btn-pdf" onclick="window.print();">&#128438; Save PDF</button>
        <a class="btn btn-excel" href="?export=excel">&#128196; Export Excel</a>
    </div>
</div>

<!-- Print-only Header -->
<div class="print-header">
    <strong style="font-size:14px;"><?php echo htmlspecialchars($pacs_name); ?></strong><br>
    <span style="font-size:12px;">Farmer Loan Report</span><br>
    <span style="font-size:10px;">Date: <?php echo date('d-M-Y'); ?></span>
</div>

<!-- Print-only Summary (Total Records + Amounts) -->
<div class="print-summary">
    <strong>Total Farmers: <?php echo $totalRecords; ?></strong> &nbsp; | &nbsp;
    Total Rabi: &#8377; <?php echo number_format($totalRabi, 2); ?> &nbsp; | &nbsp;
    Total Kharif: &#8377; <?php echo number_format($totalKharif, 2); ?> &nbsp; | &nbsp;
    Total Outstanding: &#8377; <?php echo number_format($totalOutstanding, 2); ?>
</div>

<!-- Screen Summary Cards -->
<div class="summary-strip">
    <div class="summary-card">
        <div class="label">Total Farmers</div>
        <div class="value"><?php echo $totalRecords; ?></div>
    </div>
    <div class="summary-card">
        <div class="label">Total Rabi Amount</div>
        <div class="value">&#8377; <?php echo number_format($totalRabi, 2); ?></div>
    </div>
    <div class="summary-card">
        <div class="label">Total Kharif Amount</div>
        <div class="value">&#8377; <?php echo number_format($totalKharif, 2); ?></div>
    </div>
    <div class="summary-card">
        <div class="label">Total Outstanding</div>
        <div class="value" style="color:#c0392b;">&#8377; <?php echo number_format($totalOutstanding, 2); ?></div>
    </div>
</div>

<div class="record-count">Showing <?php echo $totalRecords; ?> record(s)</div>

<!-- Data Table -->
<div class="table-wrapper">
<table id="reportTable">
    <thead>
        <tr>
            <th>Sl</th><th>Farmer Name</th><th>Father Name</th><th>Saving A/C</th>
            <th>Rabi Loan A/C</th><th>Kharif Loan A/C</th><th>EFT A/C</th><th>Village</th>
            <th>Pin</th><th>Gender</th><th>Category</th><th>Mobile</th><th>DOB</th>
            <th>Aadhar</th><th>PAN</th><th>Voter</th><th>Rabi Amt</th>
            <th>Kharif Amt</th><th>Outstanding</th>
        </tr>
    </thead>
    <tbody>
    <?php 
    if ($totalRecords > 0) {
        $sl = 1;
        foreach ($rows as $row) {
    ?>
        <tr>
            <td class="text-center"><?php echo $sl++; ?></td>
            <td><?php echo htmlspecialchars($row['Farmaers_name']); ?></td>
            <td><?php echo htmlspecialchars($row['Father_name']); ?></td>
            <td class="text-center"><?php echo htmlspecialchars($row['Saving_account']); ?></td>
            <td class="text-center"><?php echo htmlspecialchars($row['Rabi_Loan_acc']); ?></td>
            <td class="text-center"><?php echo htmlspecialchars($row['Kharif_Loan_acc']); ?></td>
            <td class="text-center"><?php echo htmlspecialchars($row['EFT_acc']); ?></td>
            <td><?php echo htmlspecialchars($row['Village']); ?></td>
            <td class="text-center"><?php echo htmlspecialchars($row['Pin_code']); ?></td>
            <td class="text-center"><?php echo htmlspecialchars($row['gender']); ?></td>
            <td class="text-center"><?php echo htmlspecialchars($row['catagory']); ?></td>
            <td class="text-center"><?php echo htmlspecialchars($row['mobile']); ?></td>
            <td class="text-center"><?php echo htmlspecialchars($row['date_of_birth']); ?></td>
            <td class="text-center"><?php echo htmlspecialchars($row['Aadher_number']); ?></td>
            <td class="text-center"><?php echo htmlspecialchars($row['Pan_number']); ?></td>
            <td><?php echo htmlspecialchars($row['Voter_name']); ?></td>
            <td class="text-right"><?php echo number_format(floatval($row['Rabi_Amount']), 2); ?></td>
            <td class="text-right"><?php echo number_format(floatval($row['Kharif_Amount']), 2); ?></td>
            <td class="text-right font-bold"><?php echo number_format(floatval($row['Loan_outstanding']), 2); ?></td>
        </tr>
    <?php 
        }
    } else {
        echo '<tr><td colspan="19" class="text-center" style="padding:30px; color:#999;">No records found</td></tr>';
    }
    ?>
    </tbody>
    <tfoot>
        <tr>
            <td colspan="16" class="text-right">Grand Total :</td>
            <td class="text-right"><?php echo number_format($totalRabi, 2); ?></td>
            <td class="text-right"><?php echo number_format($totalKharif, 2); ?></td>
            <td class="text-right"><?php echo number_format($totalOutstanding, 2); ?></td>
        </tr>
    </tfoot>
</table>
</div>

</body>
</html>